/**
 * Creator for Reader UI 
 * Object responsible for displaing list of news (main view)
 * It builds proper html templates for main view:
 *		1. list of news (items) - displays list of news fetched from feeds
 */
Application.UI.reader = (function(){
    /**
     * variable which stores value of timeout 
     * */
	var updateTimeout;
	/**
	 * Updating formatted pubDate of every displayed item
	 * element with class 'pubDate' as a propery must keep Date object with publish date of appropriate item
	 * @method updateTime 
	 * */
	function updateTime(){
		
		var items = document.getElementsByClassName( 'pubDate' );
		for( var i=0; i<items.length; i++){
			var dt = items[i].getAttribute("datetime");
			if( dt ) {
				dt = new Date(dt);
				items[i].textContent = O.Utils.Date.formatTime( dt );
			}
		}
		
	}
	
	/**
	 * Items sorting callback
	 * sorts by pubDate
	 * @method dateCompare
	 * @private
	 * @param {Object} a
	 * @param {Object} b
	 */
	function dateCompare(a,b){
		if(a.pubDate > b.pubDate){
			return -1;
		}
		if(a.pubDate < b.pubDate){
			return 1;
		}
		return 0;
	}
	
	/**
	 * Show passed items from all feeds
	 * display all items, set title of appication
	 * @method showItems
	 * @param {Array} of items
	 */
	function showItems(items){
		if(updateTimeout)clearTimeout(updateTimeout);
		if(!items.length) {
			Application.UI.overlay.showErrorMsg({
				title : 'No news',
				message : "The list of news from Your RSS feeds is empty."
			});
			return;
		}
		var title = document.getElementById( 'titleTxt' ),
			icon = document.getElementById( 'titleIcon' ),
			itemsList = document.getElementById( 'item_list' );
		
	    createItemsList(items);
	    title.textContent = APP_TITLE;
	    updateTimeout = setInterval( updateTime, 60*1000 );
	}
	
	/**
	 * displays passed items which are sorted by publish date
	 * 	prepare list of all items, bind (click,focus) events 
	 * 	set proper css-navigation attributes to organize navigation
	 * 	add navigation buttons (fakeUp,fakeDown) to prompt user when list of news is longer than view box
	 * 	set first item as active one and display its content in "#active_content" box
	 * @param {Array} of items
	 */
	function createItemsList(items){
		
		items.sort(dateCompare);
		
		var d = document,
			elem,
			itemList = d.getElementById('item_list'),
			activeItem = d.getElementById('active_item'),
			fakeUp  = d.createElement('div'),
			fakeDown = d.createElement('div');
	
		fakeUp.addClass( 'fake up disabled' );
		fakeUp.textContent = 'up';
		
		fakeDown.addClass( 'fake down' );
		fakeDown.textContent = 'down';
		
		itemList.clear();
		
		if (items.length) {
			for (var i = 0; i < items.length; i++) {
				elem = items[i].getEl();
				elem.id = 'item_'+(i)+'';
				var up = (i ? '#item_'+(i-1): '#updateBtn'),
					left = '#item_'+i,
					down = (i < items.length-1 ) ? '#item_'+(i+1) : '#item_'+i,
					right = '#openItem';
				elem.setNav(up,right,down,left);
				itemList.appendChild( elem );
			}
			itemList.appendChild( fakeUp );
			itemList.appendChild( fakeDown );
			document.getElementById('item_0').focus();
			d.getElementById('updateBtn').setNav( '#updateBtn', '#updateBtn', '#item_0', '#item_0' );
		}
		
		itemList.removeClass( 'hidden' );
		activeItem.removeClass( 'hidden' );
		if(itemList.scrollHeight <= itemList.offsetHeight+itemList.scrollTop){
			fakeDown.addClass('disabled');
		}
	}
	
	return {
        /**
         * initialize reader UI, 
         * prepare menu, 
         * set timeout for updating publish date of news
         * @method init
         * */
		init: function(){

			Application.UI.active.init();
			var updateBtn = document.getElementById('updateBtn');
			updateBtn.addEventListener( 'click', 
				function(e){ 
					e.stopPropagation();
					e.preventDefault();
					this.blur();
					Application.Reader.loadItems(); 
			}, false );
		},
		
        
        /**
         * displays items 
         * @method showItems
         * @param {Array} of items to display
         */
        showItems: showItems
    
    };
})();
